// Created with Squiffy 5.1.3
// https://github.com/textadventures/squiffy

(function(){
/* jshint quotmark: single */
/* jshint evil: true */

var squiffy = {};

(function () {
    'use strict';

    squiffy.story = {};

    var initLinkHandler = function () {
        var handleLink = function (link) {
            if (link.hasClass('disabled')) return;
            var passage = link.data('passage');
            var section = link.data('section');
            var rotateAttr = link.attr('data-rotate');
            var sequenceAttr = link.attr('data-sequence');
            if (passage) {
                disableLink(link);
                squiffy.set('_turncount', squiffy.get('_turncount') + 1);
                passage = processLink(passage);
                if (passage) {
                    currentSection.append('<hr/>');
                    squiffy.story.passage(passage);
                }
                var turnPassage = '@' + squiffy.get('_turncount');
                if (turnPassage in squiffy.story.section.passages) {
                    squiffy.story.passage(turnPassage);
                }
                if ('@last' in squiffy.story.section.passages && squiffy.get('_turncount')>= squiffy.story.section.passageCount) {
                    squiffy.story.passage('@last');
                }
            }
            else if (section) {
                currentSection.append('<hr/>');
                disableLink(link);
                section = processLink(section);
                squiffy.story.go(section);
            }
            else if (rotateAttr || sequenceAttr) {
                var result = rotate(rotateAttr || sequenceAttr, rotateAttr ? link.text() : '');
                link.html(result[0].replace(/&quot;/g, '"').replace(/&#39;/g, '\''));
                var dataAttribute = rotateAttr ? 'data-rotate' : 'data-sequence';
                link.attr(dataAttribute, result[1]);
                if (!result[1]) {
                    disableLink(link);
                }
                if (link.attr('data-attribute')) {
                    squiffy.set(link.attr('data-attribute'), result[0]);
                }
                squiffy.story.save();
            }
        };

        squiffy.ui.output.on('click', 'a.squiffy-link', function () {
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('keypress', 'a.squiffy-link', function (e) {
            if (e.which !== 13) return;
            handleLink(jQuery(this));
        });

        squiffy.ui.output.on('mousedown', 'a.squiffy-link', function (event) {
            event.preventDefault();
        });
    };

    var disableLink = function (link) {
        link.addClass('disabled');
        link.attr('tabindex', -1);
    }
    
    squiffy.story.begin = function () {
        if (!squiffy.story.load()) {
            squiffy.story.go(squiffy.story.start);
        }
    };

    var processLink = function(link) {
		link = String(link);
        var sections = link.split(',');
        var first = true;
        var target = null;
        sections.forEach(function (section) {
            section = section.trim();
            if (startsWith(section, '@replace ')) {
                replaceLabel(section.substring(9));
            }
            else {
                if (first) {
                    target = section;
                }
                else {
                    setAttribute(section);
                }
            }
            first = false;
        });
        return target;
    };

    var setAttribute = function(expr) {
        var lhs, rhs, op, value;
        var setRegex = /^([\w]*)\s*=\s*(.*)$/;
        var setMatch = setRegex.exec(expr);
        if (setMatch) {
            lhs = setMatch[1];
            rhs = setMatch[2];
            if (isNaN(rhs)) {
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
                squiffy.set(lhs, rhs);
            }
            else {
                squiffy.set(lhs, parseFloat(rhs));
            }
        }
        else {
			var incDecRegex = /^([\w]*)\s*([\+\-\*\/])=\s*(.*)$/;
            var incDecMatch = incDecRegex.exec(expr);
            if (incDecMatch) {
                lhs = incDecMatch[1];
                op = incDecMatch[2];
				rhs = incDecMatch[3];
				if(startsWith(rhs,"@")) rhs=squiffy.get(rhs.substring(1));
				rhs = parseFloat(rhs);
                value = squiffy.get(lhs);
                if (value === null) value = 0;
                if (op == '+') {
                    value += rhs;
                }
                if (op == '-') {
                    value -= rhs;
                }
				if (op == '*') {
					value *= rhs;
				}
				if (op == '/') {
					value /= rhs;
				}
                squiffy.set(lhs, value);
            }
            else {
                value = true;
                if (startsWith(expr, 'not ')) {
                    expr = expr.substring(4);
                    value = false;
                }
                squiffy.set(expr, value);
            }
        }
    };

    var replaceLabel = function(expr) {
        var regex = /^([\w]*)\s*=\s*(.*)$/;
        var match = regex.exec(expr);
        if (!match) return;
        var label = match[1];
        var text = match[2];
        if (text in squiffy.story.section.passages) {
            text = squiffy.story.section.passages[text].text;
        }
        else if (text in squiffy.story.sections) {
            text = squiffy.story.sections[text].text;
        }
        var stripParags = /^<p>(.*)<\/p>$/;
        var stripParagsMatch = stripParags.exec(text);
        if (stripParagsMatch) {
            text = stripParagsMatch[1];
        }
        var $labels = squiffy.ui.output.find('.squiffy-label-' + label);
        $labels.fadeOut(1000, function() {
            $labels.html(squiffy.ui.processText(text));
            $labels.fadeIn(1000, function() {
                squiffy.story.save();
            });
        });
    };

    squiffy.story.go = function(section) {
        squiffy.set('_transition', null);
        newSection();
        squiffy.story.section = squiffy.story.sections[section];
        if (!squiffy.story.section) return;
        squiffy.set('_section', section);
        setSeen(section);
        var master = squiffy.story.sections[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(squiffy.story.section);
        // The JS might have changed which section we're in
        if (squiffy.get('_section') == section) {
            squiffy.set('_turncount', 0);
            squiffy.ui.write(squiffy.story.section.text);
            squiffy.story.save();
        }
    };

    squiffy.story.run = function(section) {
        if (section.clear) {
            squiffy.ui.clearScreen();
        }
        if (section.attributes) {
            processAttributes(section.attributes);
        }
        if (section.js) {
            section.js();
        }
    };

    squiffy.story.passage = function(passageName) {
        var passage = squiffy.story.section.passages[passageName];
        if (!passage) return;
        setSeen(passageName);
        var masterSection = squiffy.story.sections[''];
        if (masterSection) {
            var masterPassage = masterSection.passages[''];
            if (masterPassage) {
                squiffy.story.run(masterPassage);
                squiffy.ui.write(masterPassage.text);
            }
        }
        var master = squiffy.story.section.passages[''];
        if (master) {
            squiffy.story.run(master);
            squiffy.ui.write(master.text);
        }
        squiffy.story.run(passage);
        squiffy.ui.write(passage.text);
        squiffy.story.save();
    };

    var processAttributes = function(attributes) {
        attributes.forEach(function (attribute) {
            if (startsWith(attribute, '@replace ')) {
                replaceLabel(attribute.substring(9));
            }
            else {
                setAttribute(attribute);
            }
        });
    };

    squiffy.story.restart = function() {
        if (squiffy.ui.settings.persist && window.localStorage) {
            var keys = Object.keys(localStorage);
            jQuery.each(keys, function (idx, key) {
                if (startsWith(key, squiffy.story.id)) {
                    localStorage.removeItem(key);
                }
            });
        }
        else {
            squiffy.storageFallback = {};
        }
        if (squiffy.ui.settings.scroll === 'element') {
            squiffy.ui.output.html('');
            squiffy.story.begin();
        }
        else {
            location.reload();
        }
    };

    squiffy.story.save = function() {
        squiffy.set('_output', squiffy.ui.output.html());
    };

    squiffy.story.load = function() {
        var output = squiffy.get('_output');
        if (!output) return false;
        squiffy.ui.output.html(output);
        currentSection = jQuery('#' + squiffy.get('_output-section'));
        squiffy.story.section = squiffy.story.sections[squiffy.get('_section')];
        var transition = squiffy.get('_transition');
        if (transition) {
            eval('(' + transition + ')()');
        }
        return true;
    };

    var setSeen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) seenSections = [];
        if (seenSections.indexOf(sectionName) == -1) {
            seenSections.push(sectionName);
            squiffy.set('_seen_sections', seenSections);
        }
    };

    squiffy.story.seen = function(sectionName) {
        var seenSections = squiffy.get('_seen_sections');
        if (!seenSections) return false;
        return (seenSections.indexOf(sectionName) > -1);
    };
    
    squiffy.ui = {};

    var currentSection = null;
    var screenIsClear = true;
    var scrollPosition = 0;

    var newSection = function() {
        if (currentSection) {
            disableLink(jQuery('.squiffy-link', currentSection));
        }
        var sectionCount = squiffy.get('_section-count') + 1;
        squiffy.set('_section-count', sectionCount);
        var id = 'squiffy-section-' + sectionCount;
        currentSection = jQuery('<div/>', {
            id: id,
        }).appendTo(squiffy.ui.output);
        squiffy.set('_output-section', id);
    };

    squiffy.ui.write = function(text) {
        screenIsClear = false;
        scrollPosition = squiffy.ui.output.height();
        currentSection.append(jQuery('<div/>').html(squiffy.ui.processText(text)));
        squiffy.ui.scrollToEnd();
    };

    squiffy.ui.clearScreen = function() {
        squiffy.ui.output.html('');
        screenIsClear = true;
        newSection();
    };

    squiffy.ui.scrollToEnd = function() {
        var scrollTo, currentScrollTop, distance, duration;
        if (squiffy.ui.settings.scroll === 'element') {
            scrollTo = squiffy.ui.output[0].scrollHeight - squiffy.ui.output.height();
            currentScrollTop = squiffy.ui.output.scrollTop();
            if (scrollTo > currentScrollTop) {
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.4;
                squiffy.ui.output.stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
        else {
            scrollTo = scrollPosition;
            currentScrollTop = Math.max(jQuery('body').scrollTop(), jQuery('html').scrollTop());
            if (scrollTo > currentScrollTop) {
                var maxScrollTop = jQuery(document).height() - jQuery(window).height();
                if (scrollTo > maxScrollTop) scrollTo = maxScrollTop;
                distance = scrollTo - currentScrollTop;
                duration = distance / 0.5;
                jQuery('body,html').stop().animate({ scrollTop: scrollTo }, duration);
            }
        }
    };

    squiffy.ui.processText = function(text) {
        function process(text, data) {
            var containsUnprocessedSection = false;
            var open = text.indexOf('{');
            var close;
            
            if (open > -1) {
                var nestCount = 1;
                var searchStart = open + 1;
                var finished = false;
             
                while (!finished) {
                    var nextOpen = text.indexOf('{', searchStart);
                    var nextClose = text.indexOf('}', searchStart);
         
                    if (nextClose > -1) {
                        if (nextOpen > -1 && nextOpen < nextClose) {
                            nestCount++;
                            searchStart = nextOpen + 1;
                        }
                        else {
                            nestCount--;
                            searchStart = nextClose + 1;
                            if (nestCount === 0) {
                                close = nextClose;
                                containsUnprocessedSection = true;
                                finished = true;
                            }
                        }
                    }
                    else {
                        finished = true;
                    }
                }
            }
            
            if (containsUnprocessedSection) {
                var section = text.substring(open + 1, close);
                var value = processTextCommand(section, data);
                text = text.substring(0, open) + value + process(text.substring(close + 1), data);
            }
            
            return (text);
        }

        function processTextCommand(text, data) {
            if (startsWith(text, 'if ')) {
                return processTextCommand_If(text, data);
            }
            else if (startsWith(text, 'else:')) {
                return processTextCommand_Else(text, data);
            }
            else if (startsWith(text, 'label:')) {
                return processTextCommand_Label(text, data);
            }
            else if (/^rotate[: ]/.test(text)) {
                return processTextCommand_Rotate('rotate', text, data);
            }
            else if (/^sequence[: ]/.test(text)) {
                return processTextCommand_Rotate('sequence', text, data);   
            }
            else if (text in squiffy.story.section.passages) {
                return process(squiffy.story.section.passages[text].text, data);
            }
            else if (text in squiffy.story.sections) {
                return process(squiffy.story.sections[text].text, data);
            }
			else if (startsWith(text,'@') && !startsWith(text,'@replace')) {
				processAttributes(text.substring(1).split(","));
				return "";
			}
            return squiffy.get(text);
        }

        function processTextCommand_If(section, data) {
            var command = section.substring(3);
            var colon = command.indexOf(':');
            if (colon == -1) {
                return ('{if ' + command + '}');
            }

            var text = command.substring(colon + 1);
            var condition = command.substring(0, colon);
			condition = condition.replace("<", "&lt;");
            var operatorRegex = /([\w ]*)(=|&lt;=|&gt;=|&lt;&gt;|&lt;|&gt;)(.*)/;
            var match = operatorRegex.exec(condition);

            var result = false;

            if (match) {
                var lhs = squiffy.get(match[1]);
                var op = match[2];
                var rhs = match[3];

				if(startsWith(rhs,'@')) rhs=squiffy.get(rhs.substring(1));
				
                if (op == '=' && lhs == rhs) result = true;
                if (op == '&lt;&gt;' && lhs != rhs) result = true;
                if (op == '&gt;' && lhs > rhs) result = true;
                if (op == '&lt;' && lhs < rhs) result = true;
                if (op == '&gt;=' && lhs >= rhs) result = true;
                if (op == '&lt;=' && lhs <= rhs) result = true;
            }
            else {
                var checkValue = true;
                if (startsWith(condition, 'not ')) {
                    condition = condition.substring(4);
                    checkValue = false;
                }

                if (startsWith(condition, 'seen ')) {
                    result = (squiffy.story.seen(condition.substring(5)) == checkValue);
                }
                else {
                    var value = squiffy.get(condition);
                    if (value === null) value = false;
                    result = (value == checkValue);
                }
            }

            var textResult = result ? process(text, data) : '';

            data.lastIf = result;
            return textResult;
        }

        function processTextCommand_Else(section, data) {
            if (!('lastIf' in data) || data.lastIf) return '';
            var text = section.substring(5);
            return process(text, data);
        }

        function processTextCommand_Label(section, data) {
            var command = section.substring(6);
            var eq = command.indexOf('=');
            if (eq == -1) {
                return ('{label:' + command + '}');
            }

            var text = command.substring(eq + 1);
            var label = command.substring(0, eq);

            return '<span class="squiffy-label-' + label + '">' + process(text, data) + '</span>';
        }

        function processTextCommand_Rotate(type, section, data) {
            var options;
            var attribute = '';
            if (section.substring(type.length, type.length + 1) == ' ') {
                var colon = section.indexOf(':');
                if (colon == -1) {
                    return '{' + section + '}';
                }
                options = section.substring(colon + 1);
                attribute = section.substring(type.length + 1, colon);
            }
            else {
                options = section.substring(type.length + 1);
            }
            var rotation = rotate(options.replace(/"/g, '&quot;').replace(/'/g, '&#39;'));
            if (attribute) {
                squiffy.set(attribute, rotation[0]);
            }
            return '<a class="squiffy-link" data-' + type + '="' + rotation[1] + '" data-attribute="' + attribute + '" role="link">' + rotation[0] + '</a>';
        }

        var data = {
            fulltext: text
        };
        return process(text, data);
    };

    squiffy.ui.transition = function(f) {
        squiffy.set('_transition', f.toString());
        f();
    };

    squiffy.storageFallback = {};

    squiffy.set = function(attribute, value) {
        if (typeof value === 'undefined') value = true;
        if (squiffy.ui.settings.persist && window.localStorage) {
            localStorage[squiffy.story.id + '-' + attribute] = JSON.stringify(value);
        }
        else {
            squiffy.storageFallback[attribute] = JSON.stringify(value);
        }
        squiffy.ui.settings.onSet(attribute, value);
    };

    squiffy.get = function(attribute) {
        var result;
        if (squiffy.ui.settings.persist && window.localStorage) {
            result = localStorage[squiffy.story.id + '-' + attribute];
        }
        else {
            result = squiffy.storageFallback[attribute];
        }
        if (!result) return null;
        return JSON.parse(result);
    };

    var startsWith = function(string, prefix) {
        return string.substring(0, prefix.length) === prefix;
    };

    var rotate = function(options, current) {
        var colon = options.indexOf(':');
        if (colon == -1) {
            return [options, current];
        }
        var next = options.substring(0, colon);
        var remaining = options.substring(colon + 1);
        if (current) remaining += ':' + current;
        return [next, remaining];
    };

    var methods = {
        init: function (options) {
            var settings = jQuery.extend({
                scroll: 'body',
                persist: true,
                restartPrompt: true,
                onSet: function (attribute, value) {}
            }, options);

            squiffy.ui.output = this;
            squiffy.ui.restart = jQuery(settings.restart);
            squiffy.ui.settings = settings;

            if (settings.scroll === 'element') {
                squiffy.ui.output.css('overflow-y', 'auto');
            }

            initLinkHandler();
            squiffy.story.begin();
            
            return this;
        },
        get: function (attribute) {
            return squiffy.get(attribute);
        },
        set: function (attribute, value) {
            squiffy.set(attribute, value);
        },
        restart: function () {
            if (!squiffy.ui.settings.restartPrompt || confirm('Are you sure you want to restart?')) {
                squiffy.story.restart();
            }
        }
    };

    jQuery.fn.squiffy = function (methodOrOptions) {
        if (methods[methodOrOptions]) {
            return methods[methodOrOptions]
                .apply(this, Array.prototype.slice.call(arguments, 1));
        }
        else if (typeof methodOrOptions === 'object' || ! methodOrOptions) {
            return methods.init.apply(this, arguments);
        } else {
            jQuery.error('Method ' +  methodOrOptions + ' does not exist');
        }
    };
})();

var get = squiffy.get;
var set = squiffy.set;


squiffy.story.start = 'Disclaimer';
squiffy.story.id = '56c2f0b5c6';
squiffy.story.sections = {
	'Disclaimer': {
		'text': "<p>This Interactive fiction game is made for mature audiences. Player discretion is advised. <br>\n<br>\n<a class=\"squiffy-link link-section\" data-section=\"introduction\" role=\"link\" tabindex=\"0\">Play</a></p>",
		'passages': {
		},
	},
	'introduction': {
		'text': "<p>This Interactive fiction game is based on &quot;Equation of Doom&quot; by Gerald Vance and is to serve as a sequel to some of the events presented in the story. You will experience the story from a perspective of those impacted by the major political events in the plot. Furthermore, you will play and chose what happens to Galaxy that can either be a Boon for all or be the Doom of everything. Will you enter the world of .............. <br>\n<a class=\"squiffy-link link-section\" data-section=\"start\" role=\"link\" tabindex=\"0\">Results of Doom</a></p>",
		'passages': {
		},
	},
	'start': {
		'text': "<p>Let’s get you up to speed on the state of the Galaxy. Only 1 Galactic month ago the Irwadian government had chosen to Planetarized the Transfer Service, which had banned anyone from piloting a ship that was not born on the planet nor allow them to ride on any transport off the Planet. As a result, countless people are trapped there and are forced to find low wage jobs to survive while each individual’s government enters negations for their release. The natural resource that the Galaxy wants from Irwadi is the alloy of &quot;Titanium&quot;, the primary material used in Hyperspace travel. Normally, Titanium is not naturally occurring but from what scientists concluded is that long ago during the planet&#39;s formation, 2 smaller planets must have collided and as it cooled, Titanium had formed in large sums across the world. With the Planetaration of their goods and services, the price had jumped by 10% causing mass inflation across the Galaxy. Some governments tried to curb it by placing low price ceilings on goods but in only back fires cause of the loss of trade. Quickly people started labeling the price hikes the &quot;Irwadi-Tax&quot; or more commonly &quot;Irwadi Extortion&quot;. Our story begins on a small homestead of a planet, called &quot;Homestead 7&quot;. One of 15 planets that are mostly arid desert with small patches good land for grazing and raising cattle. During the age of exploration, simple folk chose to settle down as oddly, there was no intelligent life here so it was free real estate. Let&#39;s continue on with the story.\n<a class=\"squiffy-link link-section\" data-section=\"Intro\" role=\"link\" tabindex=\"0\">Continue</a></p>",
		'passages': {
		},
	},
	'Intro': {
		'text': "<p>&quot;Hey Jodi, Ya got some booze for my girls!&quot; yelled a women clearly too drunk to understand its only 11am. &quot;You and ya girls have had way too much, I&#39;m cutting you off, go home or walk the plains&quot;, the bar tender retorted. The drunk woman pissed that she was told no more booze breaks a bottle and makes a rush for the Bar tender. But just before she could make halfway over, a gloved fist met her face, knocking her out cold. The Impact was so great that she will be feeling it for a few months. &quot;Oh thank you, Lashia, I was about to stun her with my blaster&quot;. &quot;No need for thanks, it’s my job as the bouncer for the pub&quot;, she says starring down at the would be attacker. &quot;Can you take these 3 outside, I don&#39;t want them stinking up the place before the lunch rush&quot;, Jodi said preparing the lunch menus for the cleaned empty tables. <br>\n<a class=\"squiffy-link link-section\" data-section=\"front\" role=\"link\" tabindex=\"0\">take them out front</a> <br>\n<a class=\"squiffy-link link-section\" data-section=\"back\" role=\"link\" tabindex=\"0\">Take them out back</a></p>",
		'passages': {
		},
	},
	'front': {
		'text': "<p>She takes the 3 black out drunken girls outside and leaves them at a light post just before the entrance of the building. She look down on them with eyes of pity as of course this sight is not uncommon after the sudden price hikes caused mass layoffs. “You poor souls, were always working odd jobs but now look at ya, drunkards with only sadness in your hearts”, Lashia says clapping the dust from her shirt. “Well can’t stand around here, gotta get back to work <br>\n<a class=\"squiffy-link link-section\" data-section=\"Back inside\" role=\"link\" tabindex=\"0\">Continue</a></p>",
		'passages': {
		},
	},
	'back': {
		'text': "<p>She proceeds to drag the Blackout drunk trio to the back of the building and leave them next to the dumpster. She looks down at these 3 eyes of pity as a stray dog uses them as a urinal. This makes her feel even worse for them. “Life is just takin a piss on you all”, She says. This sight is not uncommon after the sudden price hikes caused mass layoffs. Thankfully, the job of a bouncer is in constant demand.  “Well can’t stand around here, gotta get back to work <br>\n<a class=\"squiffy-link link-section\" data-section=\"Back inside\" role=\"link\" tabindex=\"0\">Continue</a>    </p>",
		'passages': {
		},
	},
	'Back inside': {
		'text': "<p>Lashia walks back to her station that normally over looks the pub on the second floor. She looks down on the bar floor reminiscing upon the nights filled with happiness and merriment. Square dances and friendly competitions of darts and arm wrestling. &quot;My, have times changed&quot;, she says with bitter sadness. On her desk sits a small black and white screen caster. Do you want to have her turn it on? <br>\n<a class=\"squiffy-link link-section\" data-section=\"turn on\" role=\"link\" tabindex=\"0\">yes</a> <br>\n<a class=\"squiffy-link link-section\" data-section=\"walk the floor\" role=\"link\" tabindex=\"0\">no</a></p>",
		'passages': {
		},
	},
	'turn on': {
		'text': "<p>The screen quickly flashes on as soon as she hits the button. The signal auto corrects itself to show a clear screen of the channel its tuned too. &quot;&quot;Hello, Ladies and Gentlemen, we bring the latest updates from the Galactic Union&quot;, says the reporter with her 2 tails moving showing clear nervousness. &quot;The Irwadian goverment is holding the rest of us hostage with their undue tax of the Galxy, Our people are suffering on their account&quot;, angrily shouted a dog man holding up papers. &quot;Need we&#39;t remind you that we are the only wonesss that have the most Titanium and Cantd do whatever we wanth&quot;, stated an Irwadian women standing with her chest puffed out. &quot;Please people, we must adhear to diplomatic protcall, we are closing this meeting and will meet in 5 Galactic days time&quot;, stated a panicked tentacle woman from inside a tank. Lashia looks on at the screen with cringe, wondering how is it possible for the average homstain can be more civil than actual diplomats. Do you wish for her to continue watching? <br>\n<a class=\"squiffy-link link-section\" data-section=\"walk the floor\" role=\"link\" tabindex=\"0\">no</a> <br>\n<a class=\"squiffy-link link-section\" data-section=\"Continue\" role=\"link\" tabindex=\"0\">yes</a></p>",
		'passages': {
		},
	},
	'Continue': {
		'text': "<p>The screen then flashes through a montage of stores around the Galaxy closing their doors. &quot;I&#39;ve been open for 150 Galactic years, now I gotta close ma doors. I can&#39;t keep up price hikes&quot; &quot;Why did my dad lose his job on a space station?&quot; &quot;Why, if I see an Irwadi snake, i&#39;ll shoot &#39;em on sight!&quot; &quot;I think it would be wise if we invade taht lizard strong hold and take all that Titanium&quot;. The broadcast continues to play sound bites from citizens across the Galaxy. Lashia shakes her head at seeing all of this, &quot;I hope somewhere out there, somebody has a plan to deal with this?&quot;. Without pomp or circumstance a massive sonic boom breaks through the air shattering all of the windows and glass in the pub, &quot;The fuck was that&quot;. She rushes outside to the streets to only be presented with the dusty dirt roads being covered with shards of glass. As she looks around at the sudden damage she looks up to see a ship burning up in the atmosphere heading toward the north of town, to some of the graving plains. She knew in an instant only she would have the guts in town to check it out. <br>\nHow will she head out out? <br>\n<a class=\"squiffy-link link-section\" data-section=\"On foot\" role=\"link\" tabindex=\"0\">On foot</a> <br>\nor <br>\n<a class=\"squiffy-link link-section\" data-section=\"Hover\" role=\"link\" tabindex=\"0\">By Hover lift</a></p>",
		'passages': {
		},
	},
	'walk the floor': {
		'text': "<p>Lashia gets up from her seat to do a walk around the pub to ensure there are no issues when patrons start to pour in. As she walks deep in thought, she notices the temperature rise. &quot;Good lord, I&#39;m building up a sweat&quot;, she says taking napkin and wiping her forehead and her bosom as the salty fluid perpetrates from her. The temperature rising as it approaches noon was not uncommon on Homestead 7. The temperature could rise as high as 100 degrees on a good day and reach 110 at the worst. Homestead 7 was filled with cool down stations every mile and people normally had portable ones too. Livestock had been equipped with some to prevent dehydration and other ills that result from the heat. At the coolest it got was 70 degrees, so everyone would sometimes have large chunks of exposed skin to prevent sweat from pooling up. For Example, Lashia normally wore boots with cooling pads, blue denim short shorts the exposed her Ebony legs, and a thin cotton shirt buttoned up or tied halfway that left her chest exposed that was topped off with a 10 gallon straw hat that was micro infused with cooling lines to keep her head cooled. Despite all the measures people take, sweating is enviable and all they can accomplish is not passing out from the heat. As she continues to wipe herself down a massive sonic boom claps across the town shattering all the glass doors and windows in the building. In a rush, she heads outside only to be greeted by broken glass littering the dusty streets. As she looks at the sudden damage, she bares witness to a ship burning up in the atmosphere heading toward the northern plains from the town&#39;s location. She knew in an instant only she would have the guts in town to check it out.<br>\nHow will she head out out? <br>\n<a class=\"squiffy-link link-section\" data-section=\"On foot\" role=\"link\" tabindex=\"0\">On foot</a> <br>\nor <br>\n<a class=\"squiffy-link link-section\" data-section=\"Hover\" role=\"link\" tabindex=\"0\">By Hover lift</a></p>",
		'passages': {
		},
	},
	'On foot': {
		'text': "<p>Lashia choosing to go by Foot stretched in place to prepare for a distant jog. She runs North toward the crashing Ship, &quot;Good thing I never skip leg day!&quot;. After her self-promoting statement she runs off into the planes. The Landscape was a mix of golden brown, tans and greens as they flowed like waves in an ocean. In her jog, Lashia remembers those days as a child running through these plains with her best friend, getting lost and finding some random junk that had been left in the open Sun for generations. She recalled having found what looked like a crashed satellite. From what they had found, it looked like an original data storage satellite used during the early days of colonization of the planet. They had been able to hack into the data stored and found details on how to care for plant life and how to form a function democratic government. However, what had their interest were recordings of animated works of what seemed to be a comedy about 2 friends in a war torn society and establish world peace while falling in love with each other. &quot;It was good time but those days had long since passed. After a moment she was snapped out of her stroll down memory lane by a massive boom but no tremor, the ship had crashed landed or at least one would think. Lashia realizing that she needed to pick up the pace, she hit a small button on her boots. Within a few seconds the cooling liner in her boots started to go too its highest setting and her normally exposed chest was suddenly covered in a sports fabric to prevent them from hitting her in the face when she picks up speed. After about a 15 minute jog, Lashia goes down a small hill that leads to one of the many small rivers that crisscross the planet she sees much to her surprise, there is no impact crater but a hovering ship made from a mix of rectangles and cubes with a massive logo on the side saying &quot;Junk Ships for Junk Prices&quot;. It rotates spinning to the right, clearly a stabilizing hover module was busted. <br></p>\n<p>Does she approch or stand there <br>\n<a class=\"squiffy-link link-section\" data-section=\"Go near\" role=\"link\" tabindex=\"0\">Approch</a>\n<a class=\"squiffy-link link-section\" data-section=\"Stand there\" role=\"link\" tabindex=\"0\">Stay</a></p>",
		'passages': {
		},
	},
	'Hover': {
		'text': "<p>Looking over to the left of the bar, sits a hover lift used in general transport of goods. Seeing it as the best method to get to the burning ship, Lashia runs over to it. Looking over it, the broken glass had thankfully fell to the front of the transport and not in the seat. Given that these types of units could be found everywhere, people considered them Public use utilizes like public transit so no one bats an eye seeing someone hope on a random transport and head off somewhere. Lashia presses the green button saying &quot;GO&quot; and heads off. For a moment she recalled being on one these with her best friend, her friend had pulled a makeshift carriage as they pretended to play Cinderella going to the ball. Among the data they had found on an old downed satellite was audio books of tons of books, one of them happen to be a book on fairy tales that were told to kids long ago on earth and from what they guessed, they still told this story on earth with multiple retellings. However, she was snapped out of her trip when she heard a massive boom further out. Lashia seeing this was no time to have such thoughts and put the transport into its highest speed. After about a 3 minute drive she is shocked to not see an impact crater but a ship made from rectangles and cubes was hovering there. A massive logo on the side saying &quot;Junk Ships for Junk Prices&quot;. it rotates spinning to the right, clearly a stabilizing hover module was busted. <br></p>\n<p>Does she approch or stand there <br>\n<a class=\"squiffy-link link-section\" data-section=\"Go near\" role=\"link\" tabindex=\"0\">Approch</a> <br>\nor <br>\n<a class=\"squiffy-link link-section\" data-section=\"Stand there\" role=\"link\" tabindex=\"0\">Stay</a>  </p>",
		'passages': {
		},
	},
	'Go near': {
		'text': "<p>Lashia choses to approach the bizarre ship with a massive amount of caution one normally should have. Her slow steps kick up small amounts of dust, leaving imprints of her boots in the dirt. Stepping closer and closer and suddenly without warning, the Ship drops to the ground with a thud. &quot;Oh shit, that scared me!&quot;, Lashia blurted holding her chest. She approaches the back of the ship as it seems to be a cargo ship that had definitely seen better days. She walked closer and closer only for the back door to fall off its hinges with the sound of rusted metal grinding together and a dusted thud like sheet metal hitting the ground. As the dust settles, Lashia is presented by a familiar face, her best friend; Honored. Lashia had not seen him in 5 years after he had left to go to some Galactic University to study minerals. &quot;Hey Lashia, been a while hasn’t it?&quot;, the man said holding on to a metal bar on the wall for dear life. Lashia was filled with much joy in seeing her old friend return home. <br></p>\n<p>How does she react? <br>\n<a class=\"squiffy-link link-section\" data-section=\"Lover\" role=\"link\" tabindex=\"0\">Like an old friend</a> <br>\nor <br>\n<a class=\"squiffy-link link-section\" data-section=\"FWB\" role=\"link\" tabindex=\"0\">Like its old times</a></p>",
		'passages': {
		},
	},
	'Stand there': {
		'text': "<p>Lashia thinks it would be best to stay where she is and investigate from a distance. After around 20 minutes of taking pictures and sending information to the local authorizes, the ship slowly lowers to the ground as a butterfly lands on a leaf. The back door slowly opens only for it to fall off the hinges. The door slams with a thud kicking up massive amounts of dust. Lashia sees a figure stumble out of the dust and sees a familiar face, her old friend; Honored. &quot;Oh my lord, you’re back&quot;, she stated dropping her phone.   </p>\n<p>How does she react? <br>\n<a class=\"squiffy-link link-section\" data-section=\"Lover\" role=\"link\" tabindex=\"0\">Like an old friend</a> <br>\nor <br>\n<a class=\"squiffy-link link-section\" data-section=\"FWB\" role=\"link\" tabindex=\"0\">Like its old times</a></p>",
		'passages': {
		},
	},
	'Lover': {
		'text': "<p>Lashia runs toward the man at a full spring with arms wide-open, &quot;Oh, it&#39;s so good to see you back!&quot;. She only a few feet away jumps up to the man, pulling him down her level and embraces him in a kiss. Pulling away, she looks up at him, &quot;You kept your promise to return to me, now we can live the life we wanted&quot;. &quot;It is good to be back but I&#39;m not here to stay long, I&#39;m here to bring you along with me. I need you&quot;, Honored says pulling back up. &quot;What do mean &quot;bring me along&quot;, are you trying to have us elope?&quot;. She starred up to him with hands on her hips noticing the clear height difference as he is a foot taller than her 5ft 2in body. Before He could explain another voice comes from behind, &quot;Have you gotten us on land yet&quot;. The source of the voice slowly comes into the light revealing her to be a Vegan woman. She walked out of the ship with an air of confidence and a massive body rarely seen from a person of her race. She walked next to Honored showing large amounts of her blue skin clad in what one would consider the uniform of a Dominatrix. Lashia with eyes closed and not so hidden venom in her tone through grit teeth, &quot;And who is this lovely lady?&quot; <br>\n<br>\nThis is the end of the Prolouge to <a class=\"squiffy-link link-section\" data-section=\"End\" role=\"link\" tabindex=\"0\">results of doom</a></p>",
		'passages': {
		},
	},
	'FWB': {
		'text': "<p>&quot;Hey honey, you fell for me so hard you fell from the sky?&quot;, Lashia said giving Honored a loving wink. &quot;You never change, do you?&quot;. &quot;Well when your girlfriend (or at least she thinks) is a Buxom lass like me, stays as perfect as a diamond in a museum. She walks up to him trying to show off the curves her 5ft 2in body had maintained. Honored years ago had joked that her body chose to focus on her feminine features instead of her height. Their relationship is somewhere in the middle between being really good friends and lovers so they are comfortable with making more sexual jokes to each other. Before Lashia was able to walk further a voice from inside the ship spoke, &quot;I thought you said this planet was mostly flat, but I see nothing but rolling hills if this girl is anything to go by&quot;. The source of the voice reveals themself to be a Vegan woman. She walked out of the ship with an air of confidence and a massive body rarely seen from a person of her race. She walked next to Honored showing large amounts of her blue skin clad in what one would consider the uniform of a Dominatrix. Lashia with eyes closed and not so hidden venom in her tone through grit teeth, &quot;And who is this lovely lady?&quot; <br>\n<br>\nThis is the end of the Prologue to <a class=\"squiffy-link link-section\" data-section=\"End\" role=\"link\" tabindex=\"0\">Results of Doom</a></p>",
		'passages': {
		},
	},
	'End': {
		'text': "<p>Thank you for playing this game and I intend to continue this in the form of bite sized games like this. Please share your thoughts and I welcome all feedback. </p>\n<p>You can contact me on Twitter @TheProg12811525</p>",
		'passages': {
		},
	},
}
})();